/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.autoupdate;

import com.quantumdata.autoupdate.AutoUpdateGUI;
import com.quantumdata.autoupdate.Device88X;
import com.quantumdata.autoupdate.Device88XException;
import com.quantumdata.autoupdate.UpgradeScreen;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;

public class IPGetGenstatsScreen
extends UpgradeScreen {
    private final String btnCancelCmd = "CANCEL";
    private final String doneCmd = "DONE";
    private JProgressBar m_progressBar;
    private Device88X m_Dev88X;
    private Action m_act;
    private Thread m_netThread;
    private JTextArea m_txtArea;

    public IPGetGenstatsScreen(String string, AutoUpdateGUI autoUpdateGUI) {
        super(string, autoUpdateGUI);
        this.configureJFrame(autoUpdateGUI);
    }

    protected void finalize() {
        System.out.println("Destroying IP Get Genstats Window");
        super.finalize();
        this.m_progressBar = null;
        this.m_netThread = null;
        this.m_txtArea = null;
    }

    private void configureJFrame(ActionListener actionListener) {
        Container container = super.getJFrame().getContentPane();
        this.m_act = new UpgradeScreen.AutomaticActionEvent(this, actionListener);
        JLabel jLabel = new JLabel("Fetching Genstats information from 88X Generator.");
        this.m_progressBar = new JProgressBar(0, 100);
        this.m_progressBar.setIndeterminate(true);
        this.m_progressBar.setValue(0);
        this.m_progressBar.setPreferredSize(new Dimension(500, 20));
        JButton jButton = new JButton("Cancel");
        jButton.setVerticalTextPosition(0);
        jButton.setHorizontalTextPosition(10);
        jButton.setMnemonic('C');
        jButton.setActionCommand("CANCEL");
        jButton.addActionListener(actionListener);
        JButton jButton2 = new JButton("Next (Test)");
        jButton2.setVerticalTextPosition(0);
        jButton2.setHorizontalTextPosition(10);
        jButton2.setMnemonic('N');
        jButton2.setActionCommand("DONE");
        jButton2.addActionListener(actionListener);
        jButton2.setVisible(false);
        this.m_txtArea = new JTextArea("");
        this.m_txtArea.setVisible(true);
        this.m_txtArea.setPreferredSize(new Dimension(500, 150));
        this.m_txtArea.setBackground(Color.BLACK);
        this.m_txtArea.setForeground(Color.white);
        this.m_txtArea.setFont(new Font("Courier New", 0, 12));
        this.m_txtArea.setEditable(false);
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        int n = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 0, n, 4);
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, n, 4);
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.m_progressBar, gridBagConstraints);
        jPanel.add(this.m_progressBar);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, n, 4);
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.m_txtArea, gridBagConstraints);
        jPanel.add(this.m_txtArea);
        JPanel jPanel2 = new JPanel();
        super.setLogo(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        container.add((Component)jPanel2, "First");
        container.add((Component)jPanel, "Center");
        container.add((Component)jPanel3, "Last");
        container.validate();
    }

    public int ScreenHandler(ActionEvent actionEvent, int n, Device88X device88X) {
        int n2 = n;
        int n3 = 0;
        if ("CANCEL".equals(actionEvent.getActionCommand())) {
            System.out.println("Exiting");
            System.exit(0);
        } else if ("DONE".equals(actionEvent.getActionCommand())) {
            Object[] objectArray = new Object[]{"Yes", "No, Try Another IP Address", "Retry", "Cancel Upgrade"};
            n3 = JOptionPane.showOptionDialog(super.getJFrame(), "Is this the Correct 88X Generator?\n\nMODEL NUMBER = " + this.m_Dev88X.getModelNum() + "\n" + "FIRMWARE VERSION = " + this.m_Dev88X.getFirmwareVer() + "\n" + "BOOT ROM VERSION = " + this.m_Dev88X.getBootRomVer() + "\n" + "GATEWARE VERSIONS = " + this.m_Dev88X.getGatewareVersions() + "\n\n", "Verify Generator Information", 1, 3, null, objectArray, objectArray[0]);
            switch (n3) {
                case 0: {
                    n2 = 5;
                    System.out.println("Check for Upgrade on website Screen: ID=" + n2);
                    break;
                }
                case 1: {
                    n2 = 2;
                    System.out.println("Re-Enter IP Address Screen: ID=" + n2);
                    break;
                }
                case 2: {
                    this.run(device88X);
                    System.out.println("Restarting Thread");
                    break;
                }
                case 3: {
                    System.out.println("Exiting");
                    System.exit(0);
                }
            }
        }
        return n2;
    }

    public void run(Device88X device88X) {
        this.m_Dev88X = device88X;
        this.m_netThread = new Thread(new runGetInfoThread());
        this.m_netThread.setName("Get 88X Info Thread");
        this.m_netThread.start();
    }

    public void refresh() {
        super.refresh();
    }

    class runGetInfoThread
    implements Runnable {
        runGetInfoThread() {
        }

        public synchronized void run() {
            ActionEvent actionEvent;
            block5: {
                actionEvent = new ActionEvent(this, 1001, "DONE");
                IPGetGenstatsScreen.this.m_act.setEnabled(true);
                if (!IPGetGenstatsScreen.this.m_Dev88X.getUpgradeInfo()) {
                    return;
                }
                IPGetGenstatsScreen.this.refresh();
                IPGetGenstatsScreen.this.m_txtArea.setText("\n        MODEL NUM:  " + IPGetGenstatsScreen.this.m_Dev88X.getModelNum() + "\n" + " FIRMWARE VERSION:  " + IPGetGenstatsScreen.this.m_Dev88X.getFirmwareVer() + "\n" + " BOOT ROM VERSION:  " + IPGetGenstatsScreen.this.m_Dev88X.getBootRomVer() + "\n" + "GATEWARE VERSIONS:  " + IPGetGenstatsScreen.this.m_Dev88X.getGatewareVersions() + "\n\n");
                try {
                    Thread.yield();
                    IPGetGenstatsScreen.this.refresh();
                    Thread.sleep(1000L);
                    IPGetGenstatsScreen.this.refresh();
                    Thread.yield();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                long l = 0L;
                try {
                    l = IPGetGenstatsScreen.this.m_Dev88X.getFlashFreeSpace(5000);
                    System.out.println("Free Flash Space = " + l);
                }
                catch (Device88XException device88XException) {
                    int n = -1;
                    Object[] objectArray = new Object[]{"Continue With Upgrade", "Cancel Upgrade"};
                    n = JOptionPane.showOptionDialog(null, "This Generator may contain an older release with an older command interface\nin which the upgrade utility may not be able to check the amount of free space on the generator\nDo you wish to continue with the upgrade?", "Free Space on Generator Unknown.", 1, 1, null, objectArray, objectArray[0]);
                    if (n != 1) break block5;
                    System.out.println("Exiting");
                    System.exit(0);
                }
            }
            IPGetGenstatsScreen.this.m_act.actionPerformed(actionEvent);
        }
    }
}

